@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an gRPC request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecGrpcRoute(
    public val action: RouteSpecGrpcRouteAction,
    public val match: RouteSpecGrpcRouteMatch? = null,
    public val retryPolicy: RouteSpecGrpcRouteRetryPolicy? = null,
    public val timeout: RouteSpecGrpcRouteTimeout? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRoute):
            RouteSpecGrpcRoute = RouteSpecGrpcRoute(
            action = javaType.action().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteAction.Companion.toKotlin(args0)
            }),
            match = javaType.match().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteRetryPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeout = javaType.timeout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteTimeout.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
