@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property port The targeted port of the weighted object.
 * @property virtualNode Virtual node to associate with the weighted target. Must be between 1 and 255 characters in length.
 * @property weight Relative weight of the weighted target. An integer between 0 and 100.
 */
public data class RouteSpecGrpcRouteActionWeightedTarget(
    public val port: Int? = null,
    public val virtualNode: String,
    public val weight: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRouteActionWeightedTarget):
            RouteSpecGrpcRouteActionWeightedTarget = RouteSpecGrpcRouteActionWeightedTarget(
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            virtualNode = javaType.virtualNode(),
            weight = javaType.weight(),
        )
    }
}
