@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property invert If `true`, the match is on the opposite of the `match` criteria. Default is `false`.
 * @property match Data to match from the request.
 * @property name Name of the route. Must be between 1 and 50 characters in length.
 */
public data class RouteSpecGrpcRouteMatchMetadata(
    public val invert: Boolean? = null,
    public val match: RouteSpecGrpcRouteMatchMetadataMatch? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRouteMatchMetadata):
            RouteSpecGrpcRouteMatchMetadata = RouteSpecGrpcRouteMatchMetadata(
            invert = javaType.invert().map({ args0 -> args0 }).orElse(null),
            match = javaType.match().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteMatchMetadataMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
        )
    }
}
