@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property exact The exact path to match on.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property range Object that specifies the range of numbers that the header value sent by the client must be included in.
 * @property regex The regex used to match the path.
 * @property suffix Header value sent by the client must end with the specified characters.
 */
public data class RouteSpecHttp2RouteMatchHeaderMatch(
    public val exact: String? = null,
    public val prefix: String? = null,
    public val range: RouteSpecHttp2RouteMatchHeaderMatchRange? = null,
    public val regex: String? = null,
    public val suffix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttp2RouteMatchHeaderMatch):
            RouteSpecHttp2RouteMatchHeaderMatch = RouteSpecHttp2RouteMatchHeaderMatch(
            exact = javaType.exact().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            range = javaType.range().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteMatchHeaderMatchRange.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regex = javaType.regex().map({ args0 -> args0 }).orElse(null),
            suffix = javaType.suffix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
