@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property exact Header value sent by the client must match the specified value exactly.
 * @property regex Header value sent by the client must include the specified characters.
 */
public data class RouteSpecHttp2RouteMatchPath(
    public val exact: String? = null,
    public val regex: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttp2RouteMatchPath):
            RouteSpecHttp2RouteMatchPath = RouteSpecHttp2RouteMatchPath(
            exact = javaType.exact().map({ args0 -> args0 }).orElse(null),
            regex = javaType.regex().map({ args0 -> args0 }).orElse(null),
        )
    }
}
