@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class RouteSpecHttp2RouteTimeout(
    public val idle: RouteSpecHttp2RouteTimeoutIdle? = null,
    public val perRequest: RouteSpecHttp2RouteTimeoutPerRequest? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttp2RouteTimeout):
            RouteSpecHttp2RouteTimeout = RouteSpecHttp2RouteTimeout(
            idle = javaType.idle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteTimeoutIdle.Companion.toKotlin(args0)
                })
            }).orElse(null),
            perRequest = javaType.perRequest().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteTimeoutPerRequest.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
