@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class RouteSpecHttpRouteTimeout(
    public val idle: RouteSpecHttpRouteTimeoutIdle? = null,
    public val perRequest: RouteSpecHttpRouteTimeoutPerRequest? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttpRouteTimeout):
            RouteSpecHttpRouteTimeout = RouteSpecHttpRouteTimeout(
            idle = javaType.idle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteTimeoutIdle.Companion.toKotlin(args0)
                })
            }).orElse(null),
            perRequest = javaType.perRequest().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteTimeoutPerRequest.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
