@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property weightedTargets Targets that traffic is routed to when a request matches the route.
 * You can specify one or more targets and their relative weights with which to distribute traffic.
 */
public data class RouteSpecTcpRouteAction(
    public val weightedTargets: List<RouteSpecTcpRouteActionWeightedTarget>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecTcpRouteAction):
            RouteSpecTcpRouteAction = RouteSpecTcpRouteAction(
            weightedTargets = javaType.weightedTargets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecTcpRouteActionWeightedTarget.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
