@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property enforce Whether the policy is enforced. Default is `true`.
 * @property ports One or more ports that the policy is enforced for.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTls(
    public val certificate: VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificate? = null,
    public val enforce: Boolean? = null,
    public val ports: List<Int>? = null,
    public val validation: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTls):
            VirtualGatewaySpecBackendDefaultsClientPolicyTls =
            VirtualGatewaySpecBackendDefaultsClientPolicyTls(
                certificate = javaType.certificate().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsCertificate.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enforce = javaType.enforce().map({ args0 -> args0 }).orElse(null),
                ports = javaType.ports().map({ args0 -> args0 }),
                validation = javaType.validation().let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation.Companion.toKotlin(args0)
                }),
            )
    }
}
