@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property acm TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust(
    public val acm: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcm? = null,
    public val `file`: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFile? = null,
    public val sds: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSds? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust):
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust(
                acm = javaType.acm().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustAcm.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                `file` = javaType.`file`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustFile.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sds = javaType.sds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrustSds.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
