@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property grpc Connection pool information for gRPC listeners.
 * @property http Connection pool information for HTTP listeners.
 * @property http2 Connection pool information for HTTP2 listeners.
 */
public data class VirtualGatewaySpecListenerConnectionPool(
    public val grpc: VirtualGatewaySpecListenerConnectionPoolGrpc? = null,
    public val http: VirtualGatewaySpecListenerConnectionPoolHttp? = null,
    public val http2: VirtualGatewaySpecListenerConnectionPoolHttp2? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListenerConnectionPool):
            VirtualGatewaySpecListenerConnectionPool = VirtualGatewaySpecListenerConnectionPool(
            grpc = javaType.grpc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerConnectionPoolGrpc.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http = javaType.http().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerConnectionPoolHttp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http2 = javaType.http2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerConnectionPoolHttp2.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
