@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property port Port used for the port mapping.
 * @property protocol Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
 */
public data class VirtualGatewaySpecListenerPortMapping(
    public val port: Int,
    public val protocol: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListenerPortMapping):
            VirtualGatewaySpecListenerPortMapping = VirtualGatewaySpecListenerPortMapping(
            port = javaType.port(),
            protocol = javaType.protocol(),
        )
    }
}
