@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property acm An AWS Certificate Manager (ACM) certificate.
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecListenerTlsCertificate(
    public val acm: VirtualGatewaySpecListenerTlsCertificateAcm? = null,
    public val `file`: VirtualGatewaySpecListenerTlsCertificateFile? = null,
    public val sds: VirtualGatewaySpecListenerTlsCertificateSds? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListenerTlsCertificate):
            VirtualGatewaySpecListenerTlsCertificate = VirtualGatewaySpecListenerTlsCertificate(
            acm = javaType.acm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsCertificateAcm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `file` = javaType.`file`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsCertificateFile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sds = javaType.sds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsCertificateSds.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
