@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property subjectAlternativeNames SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualGatewaySpecListenerTlsValidation(
    public val subjectAlternativeNames:
    VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNames? = null,
    public val trust: VirtualGatewaySpecListenerTlsValidationTrust,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListenerTlsValidation):
            VirtualGatewaySpecListenerTlsValidation = VirtualGatewaySpecListenerTlsValidation(
            subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNames.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trust = javaType.trust().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsValidationTrust.Companion.toKotlin(args0)
            }),
        )
    }
}
