@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendDefaults Defaults for backends.
 * @property backends Backends to which the virtual node is expected to send outbound traffic.
 * @property listeners Listeners from which the virtual node is expected to receive inbound traffic.
 * @property logging Inbound and outbound access logging information for the virtual node.
 * @property serviceDiscovery Service discovery information for the virtual node.
 */
public data class VirtualNodeSpec(
    public val backendDefaults: VirtualNodeSpecBackendDefaults? = null,
    public val backends: List<VirtualNodeSpecBackend>? = null,
    public val listeners: List<VirtualNodeSpecListener>? = null,
    public val logging: VirtualNodeSpecLogging? = null,
    public val serviceDiscovery: VirtualNodeSpecServiceDiscovery? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpec): VirtualNodeSpec =
            VirtualNodeSpec(
                backendDefaults = javaType.backendDefaults().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecBackendDefaults.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                backends = javaType.backends().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecBackend.Companion.toKotlin(args0)
                    })
                }),
                listeners = javaType.listeners().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListener.Companion.toKotlin(args0)
                    })
                }),
                logging = javaType.logging().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecLogging.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serviceDiscovery = javaType.serviceDiscovery().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecServiceDiscovery.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
