@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property connectionPool Connection pool information for the listener.
 * @property healthCheck Health check information for the listener.
 * @property outlierDetection Outlier detection information for the listener.
 * @property portMapping Port mapping information for the listener.
 * @property timeout Timeouts for different protocols.
 * @property tls Transport Layer Security (TLS) properties for the listener
 */
public data class VirtualNodeSpecListener(
    public val connectionPool: VirtualNodeSpecListenerConnectionPool? = null,
    public val healthCheck: VirtualNodeSpecListenerHealthCheck? = null,
    public val outlierDetection: VirtualNodeSpecListenerOutlierDetection? = null,
    public val portMapping: VirtualNodeSpecListenerPortMapping,
    public val timeout: VirtualNodeSpecListenerTimeout? = null,
    public val tls: VirtualNodeSpecListenerTls? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListener):
            VirtualNodeSpecListener = VirtualNodeSpecListener(
            connectionPool = javaType.connectionPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerConnectionPool.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthCheck = javaType.healthCheck().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerHealthCheck.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outlierDetection = javaType.outlierDetection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerOutlierDetection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            portMapping = javaType.portMapping().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerPortMapping.Companion.toKotlin(args0)
            }),
            timeout = javaType.timeout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTimeout.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTls.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
