@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property grpc Connection pool information for gRPC listeners.
 * @property http2s Connection pool information for HTTP2 listeners.
 * @property https Connection pool information for HTTP listeners.
 * @property tcps Connection pool information for TCP listeners.
 */
public data class VirtualNodeSpecListenerConnectionPool(
    public val grpc: VirtualNodeSpecListenerConnectionPoolGrpc? = null,
    public val http2s: List<VirtualNodeSpecListenerConnectionPoolHttp2>? = null,
    public val https: List<VirtualNodeSpecListenerConnectionPoolHttp>? = null,
    public val tcps: List<VirtualNodeSpecListenerConnectionPoolTcp>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerConnectionPool):
            VirtualNodeSpecListenerConnectionPool = VirtualNodeSpecListenerConnectionPool(
            grpc = javaType.grpc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerConnectionPoolGrpc.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http2s = javaType.http2s().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerConnectionPoolHttp2.Companion.toKotlin(args0)
                })
            }),
            https = javaType.https().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerConnectionPoolHttp.Companion.toKotlin(args0)
                })
            }),
            tcps = javaType.tcps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerConnectionPoolTcp.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
