@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
 * @property maxPendingRequests Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster. Minimum value of `1`.
 * The `http2` connection pool object supports the following:
 */
public data class VirtualNodeSpecListenerConnectionPoolHttp(
    public val maxConnections: Int,
    public val maxPendingRequests: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerConnectionPoolHttp):
            VirtualNodeSpecListenerConnectionPoolHttp = VirtualNodeSpecListenerConnectionPoolHttp(
            maxConnections = javaType.maxConnections(),
            maxPendingRequests = javaType.maxPendingRequests().map({ args0 -> args0 }).orElse(null),
        )
    }
}
