@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property acm An AWS Certificate Manager (ACM) certificate.
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecListenerTlsCertificate(
    public val acm: VirtualNodeSpecListenerTlsCertificateAcm? = null,
    public val `file`: VirtualNodeSpecListenerTlsCertificateFile? = null,
    public val sds: VirtualNodeSpecListenerTlsCertificateSds? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerTlsCertificate):
            VirtualNodeSpecListenerTlsCertificate = VirtualNodeSpecListenerTlsCertificate(
            acm = javaType.acm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsCertificateAcm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `file` = javaType.`file`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsCertificateFile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sds = javaType.sds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsCertificateSds.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
