@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property subjectAlternativeNames SANs for a TLS validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualNodeSpecListenerTlsValidation(
    public val subjectAlternativeNames: VirtualNodeSpecListenerTlsValidationSubjectAlternativeNames? =
        null,
    public val trust: VirtualNodeSpecListenerTlsValidationTrust,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerTlsValidation):
            VirtualNodeSpecListenerTlsValidation = VirtualNodeSpecListenerTlsValidation(
            subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsValidationSubjectAlternativeNames.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trust = javaType.trust().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsValidationTrust.Companion.toKotlin(args0)
            }),
        )
    }
}
