@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecListenerTlsValidationTrust(
    public val `file`: VirtualNodeSpecListenerTlsValidationTrustFile? = null,
    public val sds: VirtualNodeSpecListenerTlsValidationTrustSds? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerTlsValidationTrust):
            VirtualNodeSpecListenerTlsValidationTrust = VirtualNodeSpecListenerTlsValidationTrust(
            `file` = javaType.`file`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsValidationTrustFile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sds = javaType.sds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTlsValidationTrustSds.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
