@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property listeners Listeners that the virtual router is expected to receive inbound traffic from.
 * Currently only one listener is supported per virtual router.
 */
public data class VirtualRouterSpec(
    public val listeners: List<VirtualRouterSpecListener>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualRouterSpec):
            VirtualRouterSpec = VirtualRouterSpec(
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualRouterSpecListener.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
