@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property virtualNode Virtual node associated with a virtual service.
 * @property virtualRouter Virtual router associated with a virtual service.
 */
public data class VirtualServiceSpecProvider(
    public val virtualNode: VirtualServiceSpecProviderVirtualNode? = null,
    public val virtualRouter: VirtualServiceSpecProviderVirtualRouter? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualServiceSpecProvider):
            VirtualServiceSpecProvider = VirtualServiceSpecProvider(
            virtualNode = javaType.virtualNode().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualServiceSpecProviderVirtualNode.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualRouter = javaType.virtualRouter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualServiceSpecProviderVirtualRouter.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
