@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner AutoScaling Configuration Version.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AutoScalingConfigurationVersion("example", AutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationName("example")
 *             .maxConcurrency(50)
 *             .maxSize(10)
 *             .minSize(2)
 *             .tags(Map.of("Name", "example-apprunner-autoscaling"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner AutoScaling Configuration Versions using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/autoScalingConfigurationVersion:AutoScalingConfigurationVersion example "arn:aws:apprunner:us-east-1:1234567890:autoscalingconfiguration/example/1/69bdfe0115224b0db49398b7beb68e0f
 * ```
 * @property autoScalingConfigurationName Name of the auto scaling configuration.
 * @property maxConcurrency Maximal number of concurrent requests that you want an instance to process. When the number of concurrent requests goes over this limit, App Runner scales up your service.
 * @property maxSize Maximal number of instances that App Runner provisions for your service.
 * @property minSize Minimal number of instances that App Runner provisions for your service.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AutoScalingConfigurationVersionArgs(
    public val autoScalingConfigurationName: Output<String>? = null,
    public val maxConcurrency: Output<Int>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs =
        com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs.builder()
            .autoScalingConfigurationName(autoScalingConfigurationName?.applyValue({ args0 -> args0 }))
            .maxConcurrency(maxConcurrency?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AutoScalingConfigurationVersionArgs].
 */
@PulumiTagMarker
public class AutoScalingConfigurationVersionArgsBuilder internal constructor() {
    private var autoScalingConfigurationName: Output<String>? = null

    private var maxConcurrency: Output<Int>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the auto scaling configuration.
     */
    @JvmName("jqymypsdlorgemgu")
    public suspend fun autoScalingConfigurationName(`value`: Output<String>) {
        this.autoScalingConfigurationName = value
    }

    /**
     * @param value Maximal number of concurrent requests that you want an instance to process. When the number of concurrent requests goes over this limit, App Runner scales up your service.
     */
    @JvmName("qdqxhmukoxsanpbn")
    public suspend fun maxConcurrency(`value`: Output<Int>) {
        this.maxConcurrency = value
    }

    /**
     * @param value Maximal number of instances that App Runner provisions for your service.
     */
    @JvmName("qdeyovdmyikynysm")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Minimal number of instances that App Runner provisions for your service.
     */
    @JvmName("ymxrlwflpnkvqhcq")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qrbxqfcuufimrnfg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the auto scaling configuration.
     */
    @JvmName("jobbdhkuiefjxrsq")
    public suspend fun autoScalingConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingConfigurationName = mapped
    }

    /**
     * @param value Maximal number of concurrent requests that you want an instance to process. When the number of concurrent requests goes over this limit, App Runner scales up your service.
     */
    @JvmName("rkjxdfxjdgbppmfm")
    public suspend fun maxConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value Maximal number of instances that App Runner provisions for your service.
     */
    @JvmName("llprjgexiqogkmne")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Minimal number of instances that App Runner provisions for your service.
     */
    @JvmName("hxcxyaivnctvbubh")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mneiprptopaqidms")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vfwfnwupncckmkux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AutoScalingConfigurationVersionArgs = AutoScalingConfigurationVersionArgs(
        autoScalingConfigurationName = autoScalingConfigurationName,
        maxConcurrency = maxConcurrency,
        maxSize = maxSize,
        minSize = minSize,
        tags = tags,
    )
}
