@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.ConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner Connection.
 * > **NOTE:** After creation, you must complete the authentication handshake using the App Runner console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Connection;
 * import com.pulumi.aws.apprunner.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionName("example")
 *             .providerType("GITHUB")
 *             .tags(Map.of("Name", "example-apprunner-connection"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner Connections using the `connection_name`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/connection:Connection example example
 * ```
 * @property connectionName Name of the connection.
 * @property providerType Source repository provider. Valid values: `GITHUB`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val providerType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.ConnectionArgs =
        com.pulumi.aws.apprunner.ConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .providerType(providerType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var providerType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the connection.
     */
    @JvmName("pxyrpbvkaympioji")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Source repository provider. Valid values: `GITHUB`.
     */
    @JvmName("ixxyvsckjxytoxki")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xwgijhrvnaeanmyn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the connection.
     */
    @JvmName("pbkmiuvsbvxdfqoh")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Source repository provider. Valid values: `GITHUB`.
     */
    @JvmName("vqhuqsbrbtwrsusq")
    public suspend fun providerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nacxkscrvhljwyir")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hebkdgtmvtekcqfr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        connectionName = connectionName,
        providerType = providerType,
        tags = tags,
    )
}
