@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages the default App Runner auto scaling configuration.
 * When creating or updating this resource the existing default auto scaling configuration will be set to non-default automatically.
 * When creating or updating this resource the configuration is automatically assigned as the default to the new services you create in the future. The new default designation doesn't affect the associations that were previously set for existing services.
 * Each account can have only one default auto scaling configuration per Region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs;
 * import com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAutoScalingConfigurationVersion = new AutoScalingConfigurationVersion("exampleAutoScalingConfigurationVersion", AutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationName("example")
 *             .maxConcurrency(50)
 *             .maxSize(10)
 *             .minSize(2)
 *             .build());
 *         var exampleDefaultAutoScalingConfigurationVersion = new DefaultAutoScalingConfigurationVersion("exampleDefaultAutoScalingConfigurationVersion", DefaultAutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationArn(exampleAutoScalingConfigurationVersion.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner default auto scaling configurations using the current Region. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/defaultAutoScalingConfigurationVersion:DefaultAutoScalingConfigurationVersion example us-west-2
 * ```
 * @property autoScalingConfigurationArn The ARN of the App Runner auto scaling configuration that you want to set as the default.
 */
public data class DefaultAutoScalingConfigurationVersionArgs(
    public val autoScalingConfigurationArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs =
        com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs.builder()
            .autoScalingConfigurationArn(autoScalingConfigurationArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultAutoScalingConfigurationVersionArgs].
 */
@PulumiTagMarker
public class DefaultAutoScalingConfigurationVersionArgsBuilder internal constructor() {
    private var autoScalingConfigurationArn: Output<String>? = null

    /**
     * @param value The ARN of the App Runner auto scaling configuration that you want to set as the default.
     */
    @JvmName("ppjpkvguqknufyof")
    public suspend fun autoScalingConfigurationArn(`value`: Output<String>) {
        this.autoScalingConfigurationArn = value
    }

    /**
     * @param value The ARN of the App Runner auto scaling configuration that you want to set as the default.
     */
    @JvmName("aepmbsvyyuslsdos")
    public suspend fun autoScalingConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingConfigurationArn = mapped
    }

    internal fun build(): DefaultAutoScalingConfigurationVersionArgs =
        DefaultAutoScalingConfigurationVersionArgs(
            autoScalingConfigurationArn = autoScalingConfigurationArn,
        )
}
