@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.ObservabilityConfigurationTraceConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ObservabilityConfigurationTraceConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ObservabilityConfiguration].
 */
@PulumiTagMarker
public class ObservabilityConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObservabilityConfigurationArgs = ObservabilityConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObservabilityConfigurationArgsBuilder.() -> Unit) {
        val builder = ObservabilityConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ObservabilityConfiguration {
        val builtJavaResource =
            com.pulumi.aws.apprunner.ObservabilityConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ObservabilityConfiguration(builtJavaResource)
    }
}

/**
 * Manages an App Runner Observability Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ObservabilityConfiguration("example", ObservabilityConfigurationArgs.builder()
 *             .observabilityConfigurationName("example")
 *             .tags(Map.of("Name", "example-apprunner-observability-configuration"))
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor("AWSXRAY")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner Observability Configuration using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/observabilityConfiguration:ObservabilityConfiguration example arn:aws:apprunner:us-east-1:1234567890:observabilityconfiguration/example/1/d75bc7ea55b71e724fe5c23452fe22a1
 * ```
 *
 */
public class ObservabilityConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.ObservabilityConfiguration,
) : KotlinCustomResource(javaResource, ObservabilityConfigurationMapper) {
    /**
     * ARN of this observability configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether the observability configuration has the highest `observability_configuration_revision` among all configurations that share the same `observability_configuration_name`.
     */
    public val latest: Output<Boolean>
        get() = javaResource.latest().applyValue({ args0 -> args0 })

    /**
     * Name of the observability configuration.
     */
    public val observabilityConfigurationName: Output<String>
        get() = javaResource.observabilityConfigurationName().applyValue({ args0 -> args0 })

    /**
     * The revision of this observability configuration.
     */
    public val observabilityConfigurationRevision: Output<Int>
        get() = javaResource.observabilityConfigurationRevision().applyValue({ args0 -> args0 })

    /**
     * Current state of the observability configuration. An INACTIVE configuration revision has been deleted and can't be used. It is permanently removed some time after deletion.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing. See Trace Configuration below for more details.
     */
    public val traceConfiguration: Output<ObservabilityConfigurationTraceConfiguration>?
        get() = javaResource.traceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object ObservabilityConfigurationMapper : ResourceMapper<ObservabilityConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.ObservabilityConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ObservabilityConfiguration =
        ObservabilityConfiguration(
            javaResource as
                com.pulumi.aws.apprunner.ObservabilityConfiguration,
        )
}

/**
 * @see [ObservabilityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObservabilityConfiguration].
 */
public suspend fun observabilityConfiguration(
    name: String,
    block: suspend ObservabilityConfigurationResourceBuilder.() -> Unit,
):
    ObservabilityConfiguration {
    val builder = ObservabilityConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObservabilityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun observabilityConfiguration(name: String): ObservabilityConfiguration {
    val builder = ObservabilityConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
