@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs.builder
import com.pulumi.aws.apprunner.kotlin.inputs.ObservabilityConfigurationTraceConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ObservabilityConfigurationTraceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner Observability Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ObservabilityConfiguration("example", ObservabilityConfigurationArgs.builder()
 *             .observabilityConfigurationName("example")
 *             .tags(Map.of("Name", "example-apprunner-observability-configuration"))
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor("AWSXRAY")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner Observability Configuration using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/observabilityConfiguration:ObservabilityConfiguration example arn:aws:apprunner:us-east-1:1234567890:observabilityconfiguration/example/1/d75bc7ea55b71e724fe5c23452fe22a1
 * ```
 * @property observabilityConfigurationName Name of the observability configuration.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property traceConfiguration Configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing. See Trace Configuration below for more details.
 */
public data class ObservabilityConfigurationArgs(
    public val observabilityConfigurationName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val traceConfiguration: Output<ObservabilityConfigurationTraceConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.ObservabilityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.ObservabilityConfigurationArgs =
        com.pulumi.aws.apprunner.ObservabilityConfigurationArgs.builder()
            .observabilityConfigurationName(observabilityConfigurationName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .traceConfiguration(
                traceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ObservabilityConfigurationArgs].
 */
@PulumiTagMarker
public class ObservabilityConfigurationArgsBuilder internal constructor() {
    private var observabilityConfigurationName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var traceConfiguration: Output<ObservabilityConfigurationTraceConfigurationArgs>? = null

    /**
     * @param value Name of the observability configuration.
     */
    @JvmName("lowrvdgffjxftqon")
    public suspend fun observabilityConfigurationName(`value`: Output<String>) {
        this.observabilityConfigurationName = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cgkrpwyppdkyegdd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing. See Trace Configuration below for more details.
     */
    @JvmName("mltmhljaqmlsrkor")
    public suspend
    fun traceConfiguration(`value`: Output<ObservabilityConfigurationTraceConfigurationArgs>) {
        this.traceConfiguration = value
    }

    /**
     * @param value Name of the observability configuration.
     */
    @JvmName("pqseoytspbnpkikt")
    public suspend fun observabilityConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityConfigurationName = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ckeuqiswkbfpingo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hwvyegqykwfnikni")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing. See Trace Configuration below for more details.
     */
    @JvmName("bsimoyadfeewubxo")
    public suspend
    fun traceConfiguration(`value`: ObservabilityConfigurationTraceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traceConfiguration = mapped
    }

    /**
     * @param argument Configuration of the tracing feature within this observability configuration. If you don't specify it, App Runner doesn't enable tracing. See Trace Configuration below for more details.
     */
    @JvmName("tjvkvjhirdwlpjqa")
    public suspend
    fun traceConfiguration(argument: suspend ObservabilityConfigurationTraceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ObservabilityConfigurationTraceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.traceConfiguration = mapped
    }

    internal fun build(): ObservabilityConfigurationArgs = ObservabilityConfigurationArgs(
        observabilityConfigurationName = observabilityConfigurationName,
        tags = tags,
        traceConfiguration = traceConfiguration,
    )
}
