@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.ServiceEncryptionConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceHealthCheckConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceInstanceConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceObservabilityConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceEncryptionConfiguration.Companion.toKotlin as serviceEncryptionConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceHealthCheckConfiguration.Companion.toKotlin as serviceHealthCheckConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceInstanceConfiguration.Companion.toKotlin as serviceInstanceConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfiguration.Companion.toKotlin as serviceNetworkConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceObservabilityConfiguration.Companion.toKotlin as serviceObservabilityConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfiguration.Companion.toKotlin as serviceSourceConfigurationToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.aws.apprunner.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Manages an App Runner Service.
 * ## Example Usage
 * ### Service with a Code Repository Source
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .authenticationConfiguration(ServiceSourceConfigurationAuthenticationConfigurationArgs.builder()
 *                     .connectionArn(aws_apprunner_connection.example().arn())
 *                     .build())
 *                 .codeRepository(ServiceSourceConfigurationCodeRepositoryArgs.builder()
 *                     .codeConfiguration(ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder()
 *                         .codeConfigurationValues(ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder()
 *                             .buildCommand("python setup.py develop")
 *                             .port("8000")
 *                             .runtime("PYTHON_3")
 *                             .startCommand("python runapp.py")
 *                             .build())
 *                         .configurationSource("API")
 *                         .build())
 *                     .repositoryUrl("https://github.com/example/my-example-python-app")
 *                     .sourceCodeVersion(ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder()
 *                         .type("BRANCH")
 *                         .value("main")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .networkConfiguration(ServiceNetworkConfigurationArgs.builder()
 *                 .egressConfiguration(ServiceNetworkConfigurationEgressConfigurationArgs.builder()
 *                     .egressType("VPC")
 *                     .vpcConnectorArn(aws_apprunner_vpc_connector.connector().arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ### Service with an Image Repository Source
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .autoDeploymentsEnabled(false)
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ### Service with Observability Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleObservabilityConfiguration = new ObservabilityConfiguration("exampleObservabilityConfiguration", ObservabilityConfigurationArgs.builder()
 *             .observabilityConfigurationName("example")
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor("AWSXRAY")
 *                 .build())
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .serviceName("example")
 *             .observabilityConfiguration(ServiceObservabilityConfigurationArgs.builder()
 *                 .observabilityConfigurationArn(exampleObservabilityConfiguration.arn())
 *                 .observabilityEnabled(true)
 *                 .build())
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner Services using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/service:Service example arn:aws:apprunner:us-east-1:1234567890:service/example/0a03292a89764e5882c41d8f991c82fe
 * ```
 *
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * ARN of the App Runner service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     */
    public val autoScalingConfigurationArn: Output<String>
        get() = javaResource.autoScalingConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     */
    public val encryptionConfiguration: Output<ServiceEncryptionConfiguration>?
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceEncryptionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     */
    public val healthCheckConfiguration: Output<ServiceHealthCheckConfiguration>
        get() = javaResource.healthCheckConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceHealthCheckConfigurationToKotlin(args0)
            })
        })

    /**
     * The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     */
    public val instanceConfiguration: Output<ServiceInstanceConfiguration>
        get() = javaResource.instanceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceInstanceConfigurationToKotlin(args0)
            })
        })

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     */
    public val networkConfiguration: Output<ServiceNetworkConfiguration>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceNetworkConfigurationToKotlin(args0)
            })
        })

    /**
     * The observability configuration of your service. See Observability Configuration below for more details.
     */
    public val observabilityConfiguration: Output<ServiceObservabilityConfiguration>?
        get() = javaResource.observabilityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceObservabilityConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An alphanumeric ID that App Runner generated for this service. Unique within the AWS Region.
     */
    public val serviceId: Output<String>
        get() = javaResource.serviceId().applyValue({ args0 -> args0 })

    /**
     * Name of the service.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * Subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     */
    public val serviceUrl: Output<String>
        get() = javaResource.serviceUrl().applyValue({ args0 -> args0 })

    /**
     * The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * The following arguments are optional:
     */
    public val sourceConfiguration: Output<ServiceSourceConfiguration>
        get() = javaResource.sourceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceSourceConfigurationToKotlin(args0)
            })
        })

    /**
     * Current state of the App Runner service.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.aws.apprunner.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
