@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.VpcIngressConnectionIngressVpcConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.VpcIngressConnectionIngressVpcConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcIngressConnection].
 */
@PulumiTagMarker
public class VpcIngressConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIngressConnectionArgs = VpcIngressConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIngressConnectionArgsBuilder.() -> Unit) {
        val builder = VpcIngressConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIngressConnection {
        val builtJavaResource = com.pulumi.aws.apprunner.VpcIngressConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIngressConnection(builtJavaResource)
    }
}

/**
 * Manages an App Runner VPC Ingress Connection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.VpcIngressConnection;
 * import com.pulumi.aws.apprunner.VpcIngressConnectionArgs;
 * import com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcIngressConnection("example", VpcIngressConnectionArgs.builder()
 *             .serviceArn(aws_apprunner_service.example().arn())
 *             .ingressVpcConfiguration(VpcIngressConnectionIngressVpcConfigurationArgs.builder()
 *                 .vpcId(aws_default_vpc.default().id())
 *                 .vpcEndpointId(aws_vpc_endpoint.apprunner().id())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner VPC Ingress Connection using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/vpcIngressConnection:VpcIngressConnection example "arn:aws:apprunner:us-west-2:837424938642:vpcingressconnection/example/b379f86381d74825832c2e82080342fa"
 * ```
 *
 */
public class VpcIngressConnection internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.VpcIngressConnection,
) : KotlinCustomResource(javaResource, VpcIngressConnectionMapper) {
    /**
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The domain name associated with the VPC Ingress Connection resource.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource. See Ingress VPC Configuration below for more details.
     */
    public val ingressVpcConfiguration: Output<VpcIngressConnectionIngressVpcConfiguration>
        get() = javaResource.ingressVpcConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress Connections in your AWS account in the AWS Region.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection resource.
     */
    public val serviceArn: Output<String>
        get() = javaResource.serviceArn().applyValue({ args0 -> args0 })

    /**
     * The current status of the VPC Ingress Connection.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIngressConnectionMapper : ResourceMapper<VpcIngressConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.VpcIngressConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpcIngressConnection = VpcIngressConnection(
        javaResource
            as com.pulumi.aws.apprunner.VpcIngressConnection,
    )
}

/**
 * @see [VpcIngressConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIngressConnection].
 */
public suspend fun vpcIngressConnection(
    name: String,
    block: suspend VpcIngressConnectionResourceBuilder.() -> Unit,
): VpcIngressConnection {
    val builder = VpcIngressConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIngressConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIngressConnection(name: String): VpcIngressConnection {
    val builder = VpcIngressConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
