@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.VpcIngressConnectionArgs.builder
import com.pulumi.aws.apprunner.kotlin.inputs.VpcIngressConnectionIngressVpcConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.VpcIngressConnectionIngressVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner VPC Ingress Connection.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.VpcIngressConnection;
 * import com.pulumi.aws.apprunner.VpcIngressConnectionArgs;
 * import com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcIngressConnection("example", VpcIngressConnectionArgs.builder()
 *             .serviceArn(aws_apprunner_service.example().arn())
 *             .ingressVpcConfiguration(VpcIngressConnectionIngressVpcConfigurationArgs.builder()
 *                 .vpcId(aws_default_vpc.default().id())
 *                 .vpcEndpointId(aws_vpc_endpoint.apprunner().id())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Runner VPC Ingress Connection using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:apprunner/vpcIngressConnection:VpcIngressConnection example "arn:aws:apprunner:us-west-2:837424938642:vpcingressconnection/example/b379f86381d74825832c2e82080342fa"
 * ```
 * @property ingressVpcConfiguration Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource. See Ingress VPC Configuration below for more details.
 * @property name A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress Connections in your AWS account in the AWS Region.
 * @property serviceArn The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection resource.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcIngressConnectionArgs(
    public val ingressVpcConfiguration: Output<VpcIngressConnectionIngressVpcConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val serviceArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.VpcIngressConnectionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.VpcIngressConnectionArgs =
        com.pulumi.aws.apprunner.VpcIngressConnectionArgs.builder()
            .ingressVpcConfiguration(
                ingressVpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceArn(serviceArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcIngressConnectionArgs].
 */
@PulumiTagMarker
public class VpcIngressConnectionArgsBuilder internal constructor() {
    private var ingressVpcConfiguration: Output<VpcIngressConnectionIngressVpcConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var serviceArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource. See Ingress VPC Configuration below for more details.
     */
    @JvmName("btnuwlftecrhvlcq")
    public suspend
    fun ingressVpcConfiguration(`value`: Output<VpcIngressConnectionIngressVpcConfigurationArgs>) {
        this.ingressVpcConfiguration = value
    }

    /**
     * @param value A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress Connections in your AWS account in the AWS Region.
     */
    @JvmName("cjcfqekhslrlehbe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection resource.
     */
    @JvmName("tjnttejyjyellajm")
    public suspend fun serviceArn(`value`: Output<String>) {
        this.serviceArn = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("llufacbqlcgxntic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource. See Ingress VPC Configuration below for more details.
     */
    @JvmName("olramxukksetujvq")
    public suspend
    fun ingressVpcConfiguration(`value`: VpcIngressConnectionIngressVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressVpcConfiguration = mapped
    }

    /**
     * @param argument Specifications for the customer’s Amazon VPC and the related AWS PrivateLink VPC endpoint that are used to create the VPC Ingress Connection resource. See Ingress VPC Configuration below for more details.
     */
    @JvmName("jbkqqequnwtlhyyi")
    public suspend
    fun ingressVpcConfiguration(argument: suspend VpcIngressConnectionIngressVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VpcIngressConnectionIngressVpcConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ingressVpcConfiguration = mapped
    }

    /**
     * @param value A name for the VPC Ingress Connection resource. It must be unique across all the active VPC Ingress Connections in your AWS account in the AWS Region.
     */
    @JvmName("qcehmfxwmtjnjdag")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for this App Runner service that is used to create the VPC Ingress Connection resource.
     */
    @JvmName("ffftaknfsjwqynsx")
    public suspend fun serviceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xjditvnwwubsvhkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bseriwobqtaljbdy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIngressConnectionArgs = VpcIngressConnectionArgs(
        ingressVpcConfiguration = ingressVpcConfiguration,
        name = name,
        serviceArn = serviceArn,
        tags = tags,
    )
}
