@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKey ARN of the KMS key used for encryption.
 */
public data class ServiceEncryptionConfigurationArgs(
    public val kmsKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceEncryptionConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceEncryptionConfigurationArgs.builder()
            .kmsKey(kmsKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsKey: Output<String>? = null

    /**
     * @param value ARN of the KMS key used for encryption.
     */
    @JvmName("gnhobxrwlyhhxfpk")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value ARN of the KMS key used for encryption.
     */
    @JvmName("gkdkhdpldsntowki")
    public suspend fun kmsKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    internal fun build(): ServiceEncryptionConfigurationArgs = ServiceEncryptionConfigurationArgs(
        kmsKey = kmsKey ?: throw PulumiNullFieldException("kmsKey"),
    )
}
