@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceHealthCheckConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property healthyThreshold Number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
 * @property interval Time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
 * @property path URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
 * @property protocol IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
 * @property timeout Time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
 * @property unhealthyThreshold Number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
 */
public data class ServiceHealthCheckConfigurationArgs(
    public val healthyThreshold: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val path: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceHealthCheckConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceHealthCheckConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceHealthCheckConfigurationArgs.builder()
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceHealthCheckConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceHealthCheckConfigurationArgsBuilder internal constructor() {
    private var healthyThreshold: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var path: Output<String>? = null

    private var protocol: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value Number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
     */
    @JvmName("cvoolvwbkilxfqln")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value Time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
     */
    @JvmName("qeaqgelcocvgegis")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
     */
    @JvmName("micirqnxnmrdieon")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
     */
    @JvmName("vbkpmphlalkmriqr")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
     */
    @JvmName("oksxftylcdmttrym")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
     */
    @JvmName("mrvtigowsvhojvcv")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
     */
    @JvmName("wpekvpxgfavuiuxs")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value Time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
     */
    @JvmName("envekmijbrwwmcwn")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
     */
    @JvmName("jclxnidepkeblmif")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
     */
    @JvmName("lakrgvogabgatmko")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
     */
    @JvmName("jewlwfpnofokyqhf")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
     */
    @JvmName("muojghviwbncwlwh")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): ServiceHealthCheckConfigurationArgs = ServiceHealthCheckConfigurationArgs(
        healthyThreshold = healthyThreshold,
        interval = interval,
        path = path,
        protocol = protocol,
        timeout = timeout,
        unhealthyThreshold = unhealthyThreshold,
    )
}
