@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceInstanceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu Number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `256|512|1024|2048|4096|(0.25|0.5|1|2|4) vCPU`.
 * @property instanceRoleArn ARN of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
 * @property memory Amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `512|1024|2048|3072|4096|6144|8192|10240|12288|(0.5|1|2|3|4|6|8|10|12) GB`.
 */
public data class ServiceInstanceConfigurationArgs(
    public val cpu: Output<String>? = null,
    public val instanceRoleArn: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceInstanceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceInstanceConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceInstanceConfigurationArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .instanceRoleArn(instanceRoleArn?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceInstanceConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceInstanceConfigurationArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var instanceRoleArn: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `256|512|1024|2048|4096|(0.25|0.5|1|2|4) vCPU`.
     */
    @JvmName("aumxqdydmfrnojqx")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value ARN of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
     */
    @JvmName("uyfmogofkbcoduaq")
    public suspend fun instanceRoleArn(`value`: Output<String>) {
        this.instanceRoleArn = value
    }

    /**
     * @param value Amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `512|1024|2048|3072|4096|6144|8192|10240|12288|(0.5|1|2|3|4|6|8|10|12) GB`.
     */
    @JvmName("veehubmlnqolldgn")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `256|512|1024|2048|4096|(0.25|0.5|1|2|4) vCPU`.
     */
    @JvmName("kfkmyqphpppaegfn")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value ARN of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
     */
    @JvmName("puyvybmyenaaghjm")
    public suspend fun instanceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRoleArn = mapped
    }

    /**
     * @param value Amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `512|1024|2048|3072|4096|6144|8192|10240|12288|(0.5|1|2|3|4|6|8|10|12) GB`.
     */
    @JvmName("xiecepdxbdeovisg")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ServiceInstanceConfigurationArgs = ServiceInstanceConfigurationArgs(
        cpu = cpu,
        instanceRoleArn = instanceRoleArn,
        memory = memory,
    )
}
