@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property egressConfiguration Network configuration settings for outbound message traffic. See Egress Configuration below for more details.
 * @property ingressConfiguration Network configuration settings for inbound network traffic. See Ingress Configuration below for more details.
 * @property ipAddressType App Runner provides you with the option to choose between Internet Protocol version 4 (IPv4) and dual stack (IPv4 and IPv6) for your incoming public network configuration. Valid values: `IPV4`, `DUAL_STACK`. Default: `IPV4`.
 */
public data class ServiceNetworkConfigurationArgs(
    public val egressConfiguration: Output<ServiceNetworkConfigurationEgressConfigurationArgs>? =
        null,
    public val ingressConfiguration: Output<ServiceNetworkConfigurationIngressConfigurationArgs>? =
        null,
    public val ipAddressType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs.builder()
            .egressConfiguration(
                egressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ingressConfiguration(
                ingressConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkConfigurationArgsBuilder internal constructor() {
    private var egressConfiguration: Output<ServiceNetworkConfigurationEgressConfigurationArgs>? =
        null

    private var ingressConfiguration: Output<ServiceNetworkConfigurationIngressConfigurationArgs>? =
        null

    private var ipAddressType: Output<String>? = null

    /**
     * @param value Network configuration settings for outbound message traffic. See Egress Configuration below for more details.
     */
    @JvmName("qegxsoyghstinnxb")
    public suspend
    fun egressConfiguration(`value`: Output<ServiceNetworkConfigurationEgressConfigurationArgs>) {
        this.egressConfiguration = value
    }

    /**
     * @param value Network configuration settings for inbound network traffic. See Ingress Configuration below for more details.
     */
    @JvmName("aerunrewayhdjoql")
    public suspend
    fun ingressConfiguration(`value`: Output<ServiceNetworkConfigurationIngressConfigurationArgs>) {
        this.ingressConfiguration = value
    }

    /**
     * @param value App Runner provides you with the option to choose between Internet Protocol version 4 (IPv4) and dual stack (IPv4 and IPv6) for your incoming public network configuration. Valid values: `IPV4`, `DUAL_STACK`. Default: `IPV4`.
     */
    @JvmName("deoxbpsfuuqoblox")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value Network configuration settings for outbound message traffic. See Egress Configuration below for more details.
     */
    @JvmName("oweryqtbtggwaacw")
    public suspend
    fun egressConfiguration(`value`: ServiceNetworkConfigurationEgressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressConfiguration = mapped
    }

    /**
     * @param argument Network configuration settings for outbound message traffic. See Egress Configuration below for more details.
     */
    @JvmName("udjgdnnmpmyyqdwd")
    public suspend
    fun egressConfiguration(argument: suspend ServiceNetworkConfigurationEgressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNetworkConfigurationEgressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.egressConfiguration = mapped
    }

    /**
     * @param value Network configuration settings for inbound network traffic. See Ingress Configuration below for more details.
     */
    @JvmName("xfwxlqqmxrdncakt")
    public suspend
    fun ingressConfiguration(`value`: ServiceNetworkConfigurationIngressConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressConfiguration = mapped
    }

    /**
     * @param argument Network configuration settings for inbound network traffic. See Ingress Configuration below for more details.
     */
    @JvmName("arovxvrrdietavju")
    public suspend
    fun ingressConfiguration(argument: suspend ServiceNetworkConfigurationIngressConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNetworkConfigurationIngressConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ingressConfiguration = mapped
    }

    /**
     * @param value App Runner provides you with the option to choose between Internet Protocol version 4 (IPv4) and dual stack (IPv4 and IPv6) for your incoming public network configuration. Valid values: `IPV4`, `DUAL_STACK`. Default: `IPV4`.
     */
    @JvmName("cpepkfmfxhhuhddh")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    internal fun build(): ServiceNetworkConfigurationArgs = ServiceNetworkConfigurationArgs(
        egressConfiguration = egressConfiguration,
        ingressConfiguration = ingressConfiguration,
        ipAddressType = ipAddressType,
    )
}
