@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property egressType The type of egress configuration. Valid values are: `DEFAULT` and `VPC`.
 * @property vpcConnectorArn The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
 */
public data class ServiceNetworkConfigurationEgressConfigurationArgs(
    public val egressType: Output<String>? = null,
    public val vpcConnectorArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs.builder()
            .egressType(egressType?.applyValue({ args0 -> args0 }))
            .vpcConnectorArn(vpcConnectorArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNetworkConfigurationEgressConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkConfigurationEgressConfigurationArgsBuilder internal constructor() {
    private var egressType: Output<String>? = null

    private var vpcConnectorArn: Output<String>? = null

    /**
     * @param value The type of egress configuration. Valid values are: `DEFAULT` and `VPC`.
     */
    @JvmName("krgtutnpwilbkryo")
    public suspend fun egressType(`value`: Output<String>) {
        this.egressType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
     */
    @JvmName("uumwldrjypnsmxct")
    public suspend fun vpcConnectorArn(`value`: Output<String>) {
        this.vpcConnectorArn = value
    }

    /**
     * @param value The type of egress configuration. Valid values are: `DEFAULT` and `VPC`.
     */
    @JvmName("gessmojtrfslaamv")
    public suspend fun egressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
     */
    @JvmName("lraenntjoqhxltjc")
    public suspend fun vpcConnectorArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConnectorArn = mapped
    }

    internal fun build(): ServiceNetworkConfigurationEgressConfigurationArgs =
        ServiceNetworkConfigurationEgressConfigurationArgs(
            egressType = egressType,
            vpcConnectorArn = vpcConnectorArn,
        )
}
