@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationIngressConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isPubliclyAccessible Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set it to True. To make the service privately accessible, from only within an Amazon VPC set it to False.
 */
public data class ServiceNetworkConfigurationIngressConfigurationArgs(
    public val isPubliclyAccessible: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationIngressConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationIngressConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationIngressConfigurationArgs.builder()
            .isPubliclyAccessible(isPubliclyAccessible?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNetworkConfigurationIngressConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkConfigurationIngressConfigurationArgsBuilder internal constructor() {
    private var isPubliclyAccessible: Output<Boolean>? = null

    /**
     * @param value Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set it to True. To make the service privately accessible, from only within an Amazon VPC set it to False.
     */
    @JvmName("qjtbwoiecryjkbxh")
    public suspend fun isPubliclyAccessible(`value`: Output<Boolean>) {
        this.isPubliclyAccessible = value
    }

    /**
     * @param value Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set it to True. To make the service privately accessible, from only within an Amazon VPC set it to False.
     */
    @JvmName("eufqbqssnkltiekl")
    public suspend fun isPubliclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPubliclyAccessible = mapped
    }

    internal fun build(): ServiceNetworkConfigurationIngressConfigurationArgs =
        ServiceNetworkConfigurationIngressConfigurationArgs(
            isPubliclyAccessible = isPubliclyAccessible,
        )
}
