@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codeConfigurationValues Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
 * @property configurationSource Source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
 */
public data class ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs(
    public val codeConfigurationValues:
    Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs>? =
        null,
    public val configurationSource: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder()
            .codeConfigurationValues(
                codeConfigurationValues?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .configurationSource(configurationSource.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgsBuilder internal
constructor() {
    private var codeConfigurationValues:
        Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs>? =
        null

    private var configurationSource: Output<String>? = null

    /**
     * @param value Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
     */
    @JvmName("gwftkdgnpdsiugju")
    public suspend
    fun codeConfigurationValues(`value`: Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs>) {
        this.codeConfigurationValues = value
    }

    /**
     * @param value Source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
     */
    @JvmName("ljcsdehhmxhlmejh")
    public suspend fun configurationSource(`value`: Output<String>) {
        this.configurationSource = value
    }

    /**
     * @param value Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
     */
    @JvmName("uchgubtgkpcqfnvv")
    public suspend
    fun codeConfigurationValues(`value`: ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfigurationValues = mapped
    }

    /**
     * @param argument Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
     */
    @JvmName("fdxqjixrhlhdjvuk")
    public suspend
    fun codeConfigurationValues(argument: suspend ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.codeConfigurationValues = mapped
    }

    /**
     * @param value Source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
     */
    @JvmName("muoqbeidxowmlyev")
    public suspend fun configurationSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationSource = mapped
    }

    internal fun build(): ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs =
        ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs(
            codeConfigurationValues = codeConfigurationValues,
            configurationSource = configurationSource ?: throw PulumiNullFieldException("configurationSource"),
        )
}
