@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property imageConfiguration Configuration for running the identified image. See Image Configuration below for more details.
 * @property imageIdentifier Identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
 * image name format, see Pulling an image in the Amazon ECR User Guide.
 * @property imageRepositoryType Type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
 */
public data class ServiceSourceConfigurationImageRepositoryArgs(
    public val imageConfiguration:
    Output<ServiceSourceConfigurationImageRepositoryImageConfigurationArgs>? = null,
    public val imageIdentifier: Output<String>,
    public val imageRepositoryType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs> {
    override fun toJava():
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs.builder()
            .imageConfiguration(
                imageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageIdentifier(imageIdentifier.applyValue({ args0 -> args0 }))
            .imageRepositoryType(imageRepositoryType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationImageRepositoryArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationImageRepositoryArgsBuilder internal constructor() {
    private var imageConfiguration:
        Output<ServiceSourceConfigurationImageRepositoryImageConfigurationArgs>? = null

    private var imageIdentifier: Output<String>? = null

    private var imageRepositoryType: Output<String>? = null

    /**
     * @param value Configuration for running the identified image. See Image Configuration below for more details.
     */
    @JvmName("irphbopjvresjabl")
    public suspend
    fun imageConfiguration(`value`: Output<ServiceSourceConfigurationImageRepositoryImageConfigurationArgs>) {
        this.imageConfiguration = value
    }

    /**
     * @param value Identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
     * image name format, see Pulling an image in the Amazon ECR User Guide.
     */
    @JvmName("lybeoqvuvsbwvjte")
    public suspend fun imageIdentifier(`value`: Output<String>) {
        this.imageIdentifier = value
    }

    /**
     * @param value Type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
     */
    @JvmName("vhcwbohkcwqnapsn")
    public suspend fun imageRepositoryType(`value`: Output<String>) {
        this.imageRepositoryType = value
    }

    /**
     * @param value Configuration for running the identified image. See Image Configuration below for more details.
     */
    @JvmName("rxtmpolmsknmbire")
    public suspend
    fun imageConfiguration(`value`: ServiceSourceConfigurationImageRepositoryImageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageConfiguration = mapped
    }

    /**
     * @param argument Configuration for running the identified image. See Image Configuration below for more details.
     */
    @JvmName("lwjibmpotqtihclh")
    public suspend
    fun imageConfiguration(argument: suspend ServiceSourceConfigurationImageRepositoryImageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceSourceConfigurationImageRepositoryImageConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageConfiguration = mapped
    }

    /**
     * @param value Identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
     * image name format, see Pulling an image in the Amazon ECR User Guide.
     */
    @JvmName("nxxutjfyclidjtgw")
    public suspend fun imageIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageIdentifier = mapped
    }

    /**
     * @param value Type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
     */
    @JvmName("suoasfjcykeoemgd")
    public suspend fun imageRepositoryType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRepositoryType = mapped
    }

    internal fun build(): ServiceSourceConfigurationImageRepositoryArgs =
        ServiceSourceConfigurationImageRepositoryArgs(
            imageConfiguration = imageConfiguration,
            imageIdentifier = imageIdentifier ?: throw PulumiNullFieldException("imageIdentifier"),
            imageRepositoryType = imageRepositoryType ?: throw PulumiNullFieldException("imageRepositoryType"),
        )
}
