@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property port Port that your application listens to in the container. Defaults to `"8080"`.
 * @property runtimeEnvironmentSecrets Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
 * @property runtimeEnvironmentVariables Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
 * @property startCommand Command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
 */
public data class ServiceSourceConfigurationImageRepositoryImageConfigurationArgs(
    public val port: Output<String>? = null,
    public val runtimeEnvironmentSecrets: Output<Map<String, String>>? = null,
    public val runtimeEnvironmentVariables: Output<Map<String, String>>? = null,
    public val startCommand: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .runtimeEnvironmentSecrets(
                runtimeEnvironmentSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .runtimeEnvironmentVariables(
                runtimeEnvironmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .startCommand(startCommand?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationImageRepositoryImageConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationImageRepositoryImageConfigurationArgsBuilder internal
constructor() {
    private var port: Output<String>? = null

    private var runtimeEnvironmentSecrets: Output<Map<String, String>>? = null

    private var runtimeEnvironmentVariables: Output<Map<String, String>>? = null

    private var startCommand: Output<String>? = null

    /**
     * @param value Port that your application listens to in the container. Defaults to `"8080"`.
     */
    @JvmName("rebfljikurfrlpun")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("gpdeeypkvmnivlww")
    public suspend fun runtimeEnvironmentSecrets(`value`: Output<Map<String, String>>) {
        this.runtimeEnvironmentSecrets = value
    }

    /**
     * @param value Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("exombomkbeqoeaut")
    public suspend fun runtimeEnvironmentVariables(`value`: Output<Map<String, String>>) {
        this.runtimeEnvironmentVariables = value
    }

    /**
     * @param value Command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
     */
    @JvmName("xjksmgjynhqkrlhc")
    public suspend fun startCommand(`value`: Output<String>) {
        this.startCommand = value
    }

    /**
     * @param value Port that your application listens to in the container. Defaults to `"8080"`.
     */
    @JvmName("deisyeecgdwonbaa")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("cvifgfqdsajtqeio")
    public suspend fun runtimeEnvironmentSecrets(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentSecrets = mapped
    }

    /**
     * @param values Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("uagyehcbvrultwky")
    public fun runtimeEnvironmentSecrets(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeEnvironmentSecrets = mapped
    }

    /**
     * @param value Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("yqbmuijobjmuhanp")
    public suspend fun runtimeEnvironmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentVariables = mapped
    }

    /**
     * @param values Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("ytjaiicyhsbsiebs")
    public fun runtimeEnvironmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeEnvironmentVariables = mapped
    }

    /**
     * @param value Command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
     */
    @JvmName("bnnjnimqmktwpklx")
    public suspend fun startCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startCommand = mapped
    }

    internal fun build(): ServiceSourceConfigurationImageRepositoryImageConfigurationArgs =
        ServiceSourceConfigurationImageRepositoryImageConfigurationArgs(
            port = port,
            runtimeEnvironmentSecrets = runtimeEnvironmentSecrets,
            runtimeEnvironmentVariables = runtimeEnvironmentVariables,
            startCommand = startCommand,
        )
}
