@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property healthyThreshold Number of consecutive checks that must succeed before App Runner decides that the service is healthy. Defaults to 1. Minimum value of 1. Maximum value of 20.
 * @property interval Time interval, in seconds, between health checks. Defaults to 5. Minimum value of 1. Maximum value of 20.
 * @property path URL to send requests to for health checks. Defaults to `/`. Minimum length of 0. Maximum length of 51200.
 * @property protocol IP protocol that App Runner uses to perform health checks for your service. Valid values: `TCP`, `HTTP`. Defaults to `TCP`. If you set protocol to `HTTP`, App Runner sends health check requests to the HTTP path specified by `path`.
 * @property timeout Time, in seconds, to wait for a health check response before deciding it failed. Defaults to 2. Minimum value of  1. Maximum value of 20.
 * @property unhealthyThreshold Number of consecutive checks that must fail before App Runner decides that the service is unhealthy. Defaults to 5. Minimum value of  1. Maximum value of 20.
 */
public data class ServiceHealthCheckConfiguration(
    public val healthyThreshold: Int? = null,
    public val interval: Int? = null,
    public val path: String? = null,
    public val protocol: String? = null,
    public val timeout: Int? = null,
    public val unhealthyThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceHealthCheckConfiguration):
            ServiceHealthCheckConfiguration = ServiceHealthCheckConfiguration(
            healthyThreshold = javaType.healthyThreshold().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            unhealthyThreshold = javaType.unhealthyThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
