@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property egressConfiguration Network configuration settings for outbound message traffic. See Egress Configuration below for more details.
 * @property ingressConfiguration Network configuration settings for inbound network traffic. See Ingress Configuration below for more details.
 * @property ipAddressType App Runner provides you with the option to choose between Internet Protocol version 4 (IPv4) and dual stack (IPv4 and IPv6) for your incoming public network configuration. Valid values: `IPV4`, `DUAL_STACK`. Default: `IPV4`.
 */
public data class ServiceNetworkConfiguration(
    public val egressConfiguration: ServiceNetworkConfigurationEgressConfiguration? = null,
    public val ingressConfiguration: ServiceNetworkConfigurationIngressConfiguration? = null,
    public val ipAddressType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceNetworkConfiguration):
            ServiceNetworkConfiguration = ServiceNetworkConfiguration(
            egressConfiguration = javaType.egressConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfigurationEgressConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ingressConfiguration = javaType.ingressConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfigurationIngressConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
