@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property egressType The type of egress configuration. Valid values are: `DEFAULT` and `VPC`.
 * @property vpcConnectorArn The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when `EgressType = VPC`.
 */
public data class ServiceNetworkConfigurationEgressConfiguration(
    public val egressType: String? = null,
    public val vpcConnectorArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceNetworkConfigurationEgressConfiguration):
            ServiceNetworkConfigurationEgressConfiguration =
            ServiceNetworkConfigurationEgressConfiguration(
                egressType = javaType.egressType().map({ args0 -> args0 }).orElse(null),
                vpcConnectorArn = javaType.vpcConnectorArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
