@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property observabilityConfigurationArn ARN of the observability configuration that is associated with the service. Specified only when `observability_enabled` is `true`.
 * @property observabilityEnabled When `true`, an observability configuration resource is associated with the service.
 */
public data class ServiceObservabilityConfiguration(
    public val observabilityConfigurationArn: String? = null,
    public val observabilityEnabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceObservabilityConfiguration):
            ServiceObservabilityConfiguration = ServiceObservabilityConfiguration(
            observabilityConfigurationArn = javaType.observabilityConfigurationArn().map({ args0 ->
                args0
            }).orElse(null),
            observabilityEnabled = javaType.observabilityEnabled(),
        )
    }
}
