@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessRoleArn ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
 * @property connectionArn ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
 */
public data class ServiceSourceConfigurationAuthenticationConfiguration(
    public val accessRoleArn: String? = null,
    public val connectionArn: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationAuthenticationConfiguration):
            ServiceSourceConfigurationAuthenticationConfiguration =
            ServiceSourceConfigurationAuthenticationConfiguration(
                accessRoleArn = javaType.accessRoleArn().map({ args0 -> args0 }).orElse(null),
                connectionArn = javaType.connectionArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
