@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property codeConfiguration Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
 * @property repositoryUrl Location of the repository that contains the source code.
 * @property sourceCodeVersion Version that should be used within the source code repository. See Source Code Version below for more details.
 * @property sourceDirectory The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
 */
public data class ServiceSourceConfigurationCodeRepository(
    public val codeConfiguration: ServiceSourceConfigurationCodeRepositoryCodeConfiguration? = null,
    public val repositoryUrl: String,
    public val sourceCodeVersion: ServiceSourceConfigurationCodeRepositorySourceCodeVersion,
    public val sourceDirectory: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationCodeRepository):
            ServiceSourceConfigurationCodeRepository = ServiceSourceConfigurationCodeRepository(
            codeConfiguration = javaType.codeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationCodeRepositoryCodeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            repositoryUrl = javaType.repositoryUrl(),
            sourceCodeVersion = javaType.sourceCodeVersion().let({ args0 ->
                com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersion.Companion.toKotlin(args0)
            }),
            sourceDirectory = javaType.sourceDirectory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
