@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property codeConfigurationValues Basic configuration for building and running the App Runner service. Use this parameter to quickly launch an App Runner service without providing an apprunner.yaml file in the source code repository (or ignoring the file if it exists). See Code Configuration Values below for more details.
 * @property configurationSource Source of the App Runner configuration. Valid values: `REPOSITORY`, `API`. Values are interpreted as follows:
 */
public data class ServiceSourceConfigurationCodeRepositoryCodeConfiguration(
    public val codeConfigurationValues:
    ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues? = null,
    public val configurationSource: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationCodeRepositoryCodeConfiguration):
            ServiceSourceConfigurationCodeRepositoryCodeConfiguration =
            ServiceSourceConfigurationCodeRepositoryCodeConfiguration(
                codeConfigurationValues = javaType.codeConfigurationValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                configurationSource = javaType.configurationSource(),
            )
    }
}
