@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property imageConfiguration Configuration for running the identified image. See Image Configuration below for more details.
 * @property imageIdentifier Identifier of an image. For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the
 * image name format, see Pulling an image in the Amazon ECR User Guide.
 * @property imageRepositoryType Type of the image repository. This reflects the repository provider and whether the repository is private or public. Valid values: `ECR` , `ECR_PUBLIC`.
 */
public data class ServiceSourceConfigurationImageRepository(
    public val imageConfiguration: ServiceSourceConfigurationImageRepositoryImageConfiguration? =
        null,
    public val imageIdentifier: String,
    public val imageRepositoryType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationImageRepository):
            ServiceSourceConfigurationImageRepository = ServiceSourceConfigurationImageRepository(
            imageConfiguration = javaType.imageConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationImageRepositoryImageConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageIdentifier = javaType.imageIdentifier(),
            imageRepositoryType = javaType.imageRepositoryType(),
        )
    }
}
