@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property port Port that your application listens to in the container. Defaults to `"8080"`.
 * @property runtimeEnvironmentSecrets Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
 * @property runtimeEnvironmentVariables Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
 * @property startCommand Command App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.
 */
public data class ServiceSourceConfigurationImageRepositoryImageConfiguration(
    public val port: String? = null,
    public val runtimeEnvironmentSecrets: Map<String, String>? = null,
    public val runtimeEnvironmentVariables: Map<String, String>? = null,
    public val startCommand: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationImageRepositoryImageConfiguration):
            ServiceSourceConfigurationImageRepositoryImageConfiguration =
            ServiceSourceConfigurationImageRepositoryImageConfiguration(
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                runtimeEnvironmentSecrets = javaType.runtimeEnvironmentSecrets().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                runtimeEnvironmentVariables = javaType.runtimeEnvironmentVariables().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                startCommand = javaType.startCommand().map({ args0 -> args0 }).orElse(null),
            )
    }
}
