@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property vpcEndpointId The ID of the VPC endpoint that your App Runner service connects to.
 * @property vpcId The ID of the VPC that is used for the VPC endpoint.
 */
public data class VpcIngressConnectionIngressVpcConfiguration(
    public val vpcEndpointId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.VpcIngressConnectionIngressVpcConfiguration):
            VpcIngressConnectionIngressVpcConfiguration = VpcIngressConnectionIngressVpcConfiguration(
            vpcEndpointId = javaType.vpcEndpointId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
